<?php

defined( 'ABSPATH' ) || exit();

class Radio_Player_Email_Report {
	/** @var null */
	private static $instance = null;

	/**
	 * WR_Ads_Player_Email_Report constructor.
	 */
	public function __construct() {
		add_filter( 'cron_schedules', array( $this, 'cron_schedules' ) );

		$enable_statistics   = radio_player_get_setting( 'enableStats', false );
		$enable_email_report = radio_player_get_setting( 'emailReport', false );
		$interval            = radio_player_get_setting( 'emailReportInterval', 'weekly' );

		if ( ! $enable_email_report || ! $enable_statistics ) {

			wp_clear_scheduled_hook( 'radio_player_statistics_monthly_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_weekly_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_daily_report' );

			return;
		}

		if ( 'monthly' == $interval ) {
			wp_clear_scheduled_hook( 'radio_player_statistics_daily_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_weekly_report' );
		} else if ( 'weekly' == $interval ) {
			wp_clear_scheduled_hook( 'radio_player_statistics_daily_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_monthly_report' );
		} else {
			wp_clear_scheduled_hook( 'radio_player_statistics_weekly_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_monthly_report' );
		}

		add_action( 'admin_init', [ $this, 'activate_email_reporting' ] );
		add_action( "radio_player_statistics_{$interval}_report", [ $this, 'send_report' ] );
	}

	public function cron_schedules( $schedules ) {
		$schedules['monthly'] = array(
			'interval' => 2592000,
			'display'  => __( 'Once Monthly', 'radio-player' ),
		);

		return $schedules;
	}

	public function activate_email_reporting() {
		$interval = radio_player_get_setting( 'emailReportInterval', 'weekly' );

		$datetime = strtotime( "next monday 9AM", current_time( 'timestamp' ) );
		if ( 'daily' == $interval ) {
			$datetime = strtotime( "tomorrow 9AM", current_time( 'timestamp' ) );
		} elseif ( 'monthly' == $interval ) {
			$datetime = strtotime( "first day of next month 9AM", current_time( 'timestamp' ) );
		}

		if ( ! wp_next_scheduled( "radio_player_statistics_{$interval}_report" ) ) {
			wp_schedule_event( $datetime, $interval, "radio_player_statistics_{$interval}_report" );
		}
	}

	public function send_report() {
		$enable_statistics   = radio_player_get_setting( 'enableStats', false );
		$enable_email_report = radio_player_get_setting( 'emailReport', false );
		$interval            = radio_player_get_setting( 'emailReportInterval', 'weekly' );

		if ( ! $enable_email_report || ! $enable_statistics ) {
			wp_clear_scheduled_hook( 'radio_player_statistics_monthly_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_weekly_report' );
			wp_clear_scheduled_hook( 'radio_player_statistics_daily_report' );

			return;
		}

		$length = 7;
		if ( 'monthly' == $interval ) {
			$length = 30;
		} elseif ( 'daily' == $interval ) {
			$length = 1;
		}

		$start_date = date( 'Y-m-d', strtotime( "-{$length} days" ) );
		$end_date   = date( 'Y-m-d' );

		if ( ! class_exists( 'Radio_Player_Statistics' ) ) {
			require_once RADIO_PLAYER_INCLUDES . '/class-statistics__premium_only.php';
		}

		$instance = Radio_Player_Statistics::instance();
		$players = $instance->get_top_players( $start_date, $end_date );
		$logs	= $instance->get_logs( $start_date, $end_date );

		$send_to = radio_player_get_setting( 'reportingEmail', get_option( 'admin_email' ) );
		$subject = __( 'Radio player statistics of last ', 'radio-player' ) . sprintf( _n( ' %s day', ' %s days', $length, 'radio-player' ), $length );

		ob_start();
		include_once RADIO_PLAYER_INCLUDES . '/views/email-report.php';
		$email_message = ob_get_clean();

		$headers = array( 'Content-Type: text/html; charset=UTF-8' );

		wp_mail( $send_to, $subject, $email_message, $headers );
	}

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}
}

Radio_Player_Email_Report::instance();